from fastapi import APIRouter, Depends, HTTPException
from app.db import database
from app.v1.models.platform.communication import CommunicationSettings
from app.v1.services.platform import communication as communication_service

router = APIRouter()

@router.get("/", response_model=CommunicationSettings)
def get_settings(db: database.MongoDB = Depends(database.get_mongo_db)):
    try:
        return communication_service.get_communication_settings(db)
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

# @router.post("/", response_model=CommunicationSettings)
# def update_settings(settings: CommunicationSettings, db: database.MongoDB = Depends(database.get_mongo_db)):
#     print("communicationcommunicationcommunication")
#     try:
#         return communication_service.update_communication_settings(settings.dict(), db)
#     except Exception as e:
#         raise HTTPException(status_code=500, detail=str(e))

@router.post("/{account_id}", response_model=CommunicationSettings)
def update_settings(account_id: str, settings: CommunicationSettings, db=Depends(database.get_mongo_db)):
    return communication_service.update_communication_settings(account_id, settings.dict(), db)

